//=============================================================================
// StatusDel.js
//=============================================================================

/*:ja
 * @plugindesc 既存のパラメーターの表示非表示を設定します
 * @author TRS
 *
 * @help　このプラグインはパラメータ設定だけです　※装備部分の設定はツクール上で設定
 *
 * @param LV表示
 * @type boolean
 * @desc LV表示
 * @default true
 *
 * @param 経験値表示
 * @type boolean
 * @desc 経験値表示
 * @default true
 
 * @param HP表示
 * @type boolean
 * @desc HP表示
 * @default true
 *
 * @param MP表示
 * @type boolean
 * @desc MP表示
 * @default false
 *
 * @param 魔力から下表示
 * @type boolean
 * @desc 魔力から下表示
 * @default false
 *
 * @param G表示
 * @type boolean
 * @desc ゴールドウィンドウ表示
 * @default false
 * 
 * @help
 */

(function()
{
	var parameters = PluginManager.parameters('StatusDel');
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	
	var isLvVisible = parameters['LV表示'] || true;
	var isHpVisible = parameters['HP表示'] || true;
	var isMpVisible = parameters['MP表示'] || true;
	var isExpVisible = parameters['経験値表示'] || true;
	
	var isMagicIkaHyouji = parameters['魔力から下表示'] || false;
	var isGoldHyouji = parameters['G表示'] || false;
	
	var isFantasyStatus 
	
	/**
	 *	メニューウィンドウ作成
	 */
	Scene_Menu.prototype.create = function() 
	{
	    Scene_MenuBase.prototype.create.call(this);
	    this.createCommandWindow();
	    if( isGoldHyouji === true)
			this.createGoldWindow();
	    
	    this.createStatusWindow();
	};

	//-------------------------------------------------------------------------
	//    ステータスウィンドウ（Lv,Hp,Mp ）
	//
	//-----------------------------------------------------------------------------
	// Window_Status　オーバーライド部
	//
	// The window for displaying full status on the status screen.
	
	Window_Status.prototype.drawBlock2 = function(y) {
	    this.drawActorFace(this._actor, 12, y);
	    this.drawBasicInfo(204, y);
	    
	    if( isExpVisible == "true")
	    	this.drawExpInfo(456, y);
	};

	Window_Status.prototype.drawBlock3 = function(y) {
	    this.drawParameters(48, y);
	    this.drawEquipments(432, y);
	};

	Window_Status.prototype.drawBlock4 = function(y) {
	    this.drawProfile(6, y);
	};

	Window_Status.prototype.drawHorzLine = function(y) {
	    var lineY = y + this.lineHeight() / 2 - 1;
	    this.contents.paintOpacity = 48;
	    this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.lineColor());
	    this.contents.paintOpacity = 255;
	};

	Window_Status.prototype.lineColor = function() {
	    return this.normalColor();
	};

	Window_Status.prototype.drawBasicInfo = function(x, y) {
	    var lineHeight = this.lineHeight();
	    
		//LV表示
	    if( isLvVisible == "true" )
	    	this.drawActorLevel(this._actor, x, y + lineHeight * 0);
	    
    	this.drawActorIcons(this._actor, x, y + lineHeight * 1);
    	
    	//HP表示
    	if(isHpVisible == "true")
    		this.drawActorHp(this._actor, x, y + lineHeight * 2);
    	
    	//MP表示
    	if(isMpVisible == "true")
    		this.drawActorMp(this._actor, x, y + lineHeight * 3);
	};

	Window_Status.prototype.drawParameters = function(x, y) {
	    var lineHeight = this.lineHeight();
	    
	    //描画するもの
	    var varParam3Ika;					//パラメータ3列目以下
	    
	    //魔力以下描画しない
	    if(isMagicIkaHyouji == "false")
	    	varParam3Ika = 2
	    
	    //魔力以下描画する
	    else
	    	varParam3Ika = 6
	    	
	    for (var i = 0; i < varParam3Ika; i++) {
	        var paramId = i + 2;
	        var y2 = y + lineHeight * i;
	        this.changeTextColor(this.systemColor());
	        this.drawText(TextManager.param(paramId), x, y2, 160);
	        this.resetTextColor();
	        this.drawText(this._actor.param(paramId), x + 160, y2, 60, 'right');
	    }
	};

	Window_Status.prototype.drawExpInfo = function(x, y) {
	    var lineHeight = this.lineHeight();
	    var expTotal = TextManager.expTotal.format(TextManager.exp);
	    var expNext = TextManager.expNext.format(TextManager.level);
	    var value1 = this._actor.currentExp();
	    var value2 = this._actor.nextRequiredExp();
	    if (this._actor.isMaxLevel()) {
	        value1 = '-------';
	        value2 = '-------';
	    }
	    this.changeTextColor(this.systemColor());
	    this.drawText(expTotal, x, y + lineHeight * 0, 270);
	    this.drawText(expNext, x, y + lineHeight * 2, 270);
	    this.resetTextColor();
	    this.drawText(value1, x, y + lineHeight * 1, 270, 'right');
	    this.drawText(value2, x, y + lineHeight * 3, 270, 'right');
	};

	Window_Status.prototype.drawEquipments = function(x, y) {
	    var equips = this._actor.equips();
	    var count = Math.min(equips.length, this.maxEquipmentLines());
	    for (var i = 0; i < count; i++) {
	        this.drawItemName(equips[i], x, y + this.lineHeight() * i);
	    }
	};

	Window_Status.prototype.drawProfile = function(x, y) {
	    this.drawTextEx(this._actor.profile(), x, y);
	};

	Window_Status.prototype.maxEquipmentLines = function() {
	    return 6;
	};
	
	/**
	 * 装備パラメーターオーバーライド
	 */
	Window_EquipStatus.prototype.refresh = function() {
	    this.contents.clear();
	     //描画するもの
	    var varParam3Ika;					//パラメータ3列目以下
	    
	    //魔力以下描画しない
	    if(isMagicIkaHyouji == "false")
	    	varParam3Ika = 2
	    
	    //魔力以下描画する
	    else
	    	varParam3Ika = 6
	    	
	    if (this._actor) {
	        this.drawActorName(this._actor, this.textPadding(), 0);
	        for (var i = 0; i < varParam3Ika; i++) {
	            this.drawItem(0, this.lineHeight() * (1 + i), 2 + i);
	        }
	    }
	};
	
})();
